package transferobservers

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type NightTransferObserver struct {
}

func NewNightTransferObserver() *NightTransferObserver {
	return &NightTransferObserver{}
}

func (o *NightTransferObserver) Observe(transfers *aviaSearchProto.Transfers) {
}

func (o *NightTransferObserver) FillInitialFilterResponse(filters *aviaAPI.SearchFiltersReq, filterResponse *aviaAPI.SearchFiltersRsp) {
	filterResponse.Transfer.NoNightTransfer = &aviaAPI.SearchFiltersRsp_BoolFilterState{
		Enabled: true,
		Value:   false,
	}
	if filters != nil && filters.Transfer != nil {
		filterResponse.Transfer.NoNightTransfer.Value = filters.Transfer.NoNightTransfer
	}
}

func (o *NightTransferObserver) UpdateFilterResponse(filterResponse *aviaAPI.SearchFiltersRsp) {
}
