package transferobservers

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type NoTransferObserver struct {
	hasSnippets bool
	hasTransfer bool
	hasDirect   bool
}

func NewNoTransferObserver() *NoTransferObserver {
	return &NoTransferObserver{
		hasSnippets: false,
		hasTransfer: false,
		hasDirect:   false,
	}
}

func (o *NoTransferObserver) Observe(transfers *aviaSearchProto.Transfers) {
	o.hasSnippets = true
	if len(transfers.ForwardTransfers) == 0 && len(transfers.BackwardTransfers) == 0 {
		o.hasDirect = true
	} else {
		o.hasTransfer = true
	}
}

func (o *NoTransferObserver) FillInitialFilterResponse(filters *aviaAPI.SearchFiltersReq, filterResponse *aviaAPI.SearchFiltersRsp) {
	f := &aviaAPI.SearchFiltersRsp_BoolFilterState{}

	if filters != nil {
		f.Value = filters.QuickTransfer
	}

	// если все рейсы только прямые, или если все рейсы только с пересадками, то состояние фильтра надо исправить
	if o.hasSnippets {
		if o.hasDirect && !o.hasTransfer {
			f.Value = true
		}
		if o.hasTransfer && !o.hasDirect {
			f.Value = false
		}
	}

	filterResponse.QuickTransfer.State = f
	filterResponse.Transfer.NoTransfer = f
}

func (o *NoTransferObserver) UpdateFilterResponse(filterResponse *aviaAPI.SearchFiltersRsp) {
	filterResponse.QuickTransfer.State.Enabled = o.hasTransfer && o.hasDirect
	filterResponse.Transfer.NoTransfer.Enabled = o.hasTransfer && o.hasDirect
}
