package transferobservers

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type OneOrLessTransferObserver struct {
	hasSnippets bool

	hasOneOrLessTransfer   bool
	hasMoreThanOneTransfer bool
}

func NewOneOrLessTransferObserver() *OneOrLessTransferObserver {
	return &OneOrLessTransferObserver{
		hasSnippets:            false,
		hasOneOrLessTransfer:   false,
		hasMoreThanOneTransfer: false,
	}
}

func (o *OneOrLessTransferObserver) Observe(transfers *aviaSearchProto.Transfers) {
	o.hasSnippets = true

	if len(transfers.ForwardTransfers) > 1 || len(transfers.BackwardTransfers) > 1 {
		o.hasMoreThanOneTransfer = true
	} else {
		o.hasOneOrLessTransfer = true
	}
}

func (o *OneOrLessTransferObserver) FillInitialFilterResponse(filters *aviaAPI.SearchFiltersReq, filterResponse *aviaAPI.SearchFiltersRsp) {
	f := &aviaAPI.SearchFiltersRsp_BoolFilterState{}

	if filters != nil && filters.Transfer != nil {
		f.Value = filters.Transfer.OneTransferOrLess
	}

	// если все рейсы только c больше чем одной пересадкой,
	// или если все рейсы только с одной пересадкой или меньше, то состояние фильтра надо исправить
	if o.hasSnippets {
		if o.hasOneOrLessTransfer && !o.hasMoreThanOneTransfer {
			f.Value = true
		}
		if o.hasMoreThanOneTransfer && !o.hasOneOrLessTransfer {
			f.Value = false
		}
	}

	filterResponse.Transfer.OneTransferOrLess = f
}

func (o *OneOrLessTransferObserver) UpdateFilterResponse(filterResponse *aviaAPI.SearchFiltersRsp) {
	filterResponse.Transfer.OneTransferOrLess.Enabled = o.hasMoreThanOneTransfer && o.hasOneOrLessTransfer
}
