package airport

import (
	"sort"

	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	aviaProtoV2 "a.yandex-team.ru/travel/avia/library/proto/common/v2"
	"a.yandex-team.ru/travel/library/go/containers"
)

func getAirports(
	idsInSnippets containers.Set[uint64],
	idsInRequest containers.Set[uint64],
	reference *aviaSearchProto.Reference,
) []*aviaAPI.SearchFiltersRsp_Airport {
	settlementIDs := containers.SetOf[uint64]()
	for aID := range idsInSnippets {
		settlementIDs.Add(reference.Stations[aID].SettlementId)
	}
	needSettlementTitle := len(settlementIDs) > 1

	airports := make([]*aviaAPI.SearchFiltersRsp_Airport, 0, len(idsInSnippets))
	for aID := range idsInSnippets {
		station := reference.Stations[aID]
		a := &aviaAPI.SearchFiltersRsp_Airport{
			State: &aviaAPI.SearchFiltersRsp_BoolFilterState{
				Enabled: true,
			},
			StationId:       aID,
			StationTitle:    station.Title,
			SettlementTitle: "",
			AviaCode:        station.AviaCode,
		}
		if needSettlementTitle && station.SettlementId != 0 {
			a.SettlementTitle = reference.Settlements[station.SettlementId].Title
		}
		if idsInRequest.Contains(aID) {
			a.State.Value = true
		}
		airports = append(airports, a)
	}
	sort.SliceStable(airports, func(i, j int) bool {
		return airports[i].StationId < airports[j].StationId
	})

	return airports
}

func getSettlementID(point *aviaProtoV2.Point) uint64 {
	if point.Type == aviaProtoV2.PointType_POINT_TYPE_SETTLEMENT {
		return point.Id
	}
	return 0
}
