package filterinterface

import (
	"a.yandex-team.ru/travel/library/go/containers"
)

type ExcludedKeys struct {
	snippetKeys containers.Set[string]
	variantKeys containers.Set[string]
}

func NewExcludedKeys() *ExcludedKeys {
	return &ExcludedKeys{
		snippetKeys: containers.SetOf[string](),
		variantKeys: containers.SetOf[string](),
	}
}

func (k *ExcludedKeys) AddSnippetKey(sKey string) {
	k.snippetKeys.Add(sKey)
}

func (k *ExcludedKeys) AddVariantKey(sKey, vKey string) {
	k.variantKeys.Add(buildFullVariantKey(sKey, vKey))
}

func (k *ExcludedKeys) GetSnippetKeys() []string {
	return k.snippetKeys.Values()
}

func (k *ExcludedKeys) GetVariantKeys() []string {
	return k.variantKeys.Values()
}

func (k *ExcludedKeys) ContainsSnippetKey(sKey string) bool {
	return k.snippetKeys.Contains(sKey)
}

func (k *ExcludedKeys) ContainsVariantKey(sKey, vKey string) bool {
	return k.variantKeys.Contains(buildFullVariantKey(sKey, vKey))
}

type ExcludedKeysByFilter map[string]*ExcludedKeys

func NewExcludedKeysByFilter(fs []SearchFilterInterface) ExcludedKeysByFilter {
	excludedKeysByFilter := make(ExcludedKeysByFilter, len(fs))
	for _, f := range fs {
		excludedKeysByFilter[f.GetFilterID()] = &ExcludedKeys{
			snippetKeys: containers.SetOf[string](),
			variantKeys: containers.SetOf[string](),
		}
	}
	return excludedKeysByFilter
}

func (e ExcludedKeysByFilter) UniteAll() *ExcludedKeys {
	r := &ExcludedKeys{
		snippetKeys: containers.SetOf[string](),
		variantKeys: containers.SetOf[string](),
	}
	for _, keys := range e {
		for _, sKey := range keys.GetSnippetKeys() {
			r.snippetKeys.Add(sKey)
		}
		for _, vKey := range keys.GetVariantKeys() {
			r.variantKeys.Add(vKey)
		}
	}
	return r
}

func (e ExcludedKeysByFilter) UniteWithoutOne(exception string) *ExcludedKeys {
	r := &ExcludedKeys{
		snippetKeys: containers.SetOf[string](),
		variantKeys: containers.SetOf[string](),
	}
	for name, keys := range e {
		if name == exception {
			continue
		}
		for _, sKey := range keys.GetSnippetKeys() {
			r.snippetKeys.Add(sKey)
		}
		for _, vKey := range keys.GetVariantKeys() {
			r.variantKeys.Add(vKey)
		}
	}
	return r
}

func buildFullVariantKey(snippetKey, variantKey string) string {
	return snippetKey + "@" + variantKey
}
