package filterinterface

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type SearchFilterInterface interface {
	GetFilterID() string
	InitFilterResponse(
		filters *aviaAPI.SearchFiltersReq,
		snippets map[string]*aviaSearchProto.Snippet,
		reference *aviaSearchProto.Reference,
		searchContext *aviaSearchProto.SearchContext,
		filterResponse *aviaAPI.SearchFiltersRsp,
	) *aviaAPI.SearchFiltersRsp
	Filter(
		filters *aviaAPI.SearchFiltersReq,
		snippets map[string]*aviaSearchProto.Snippet,
		reference *aviaSearchProto.Reference,
		filterResponse *aviaAPI.SearchFiltersRsp,
	) *ExcludedKeys
	UpdateFilterResponse(
		snippets map[string]*aviaSearchProto.Snippet,
		excludedKeysByOthers *ExcludedKeys,
		reference *aviaSearchProto.Reference,
		filterResponse *aviaAPI.SearchFiltersRsp,
	) *aviaAPI.SearchFiltersRsp
}
