package timefilter

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
)

func inInterval(value string, interval *aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval) bool {
	if interval == nil {
		return true
	}
	return interval.MinDatetime <= value && value <= interval.MaxDatetime
}

func copyIntervalFromRequest(from *aviaAPI.SearchFiltersReq_DepartureOrArrivalInterval) *aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval {
	if from == nil {
		return nil
	}
	return &aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval{
		MinDatetime: from.MinDatetime,
		MaxDatetime: from.MaxDatetime,
	}
}

func copyIntervalFromResponse(from *aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval) *aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval {
	if from == nil {
		return nil
	}
	return &aviaAPI.SearchFiltersRsp_DepartureOrArrivalInterval{
		MinDatetime: from.MinDatetime,
		MaxDatetime: from.MaxDatetime,
	}
}

func fitSelectedIntoAll(v *aviaAPI.SearchFiltersRsp_DepartureOrArrivalState) {
	if v != nil {
		if v.All != nil {
			if v.Selected == nil {
				v.Selected = copyIntervalFromResponse(v.All)
			} else {
				if v.Selected.MinDatetime == "" || v.Selected.MinDatetime < v.All.MinDatetime {
					v.Selected.MinDatetime = v.All.MinDatetime
				}
				if v.Selected.MaxDatetime == "" || v.Selected.MaxDatetime > v.All.MaxDatetime {
					v.Selected.MaxDatetime = v.All.MaxDatetime
				}
			}
		}
	}
}

func needToApplyFilter(v *aviaAPI.SearchFiltersRsp_DepartureOrArrivalState) bool {
	if v == nil {
		return false
	}
	if v.Selected == nil || v.All == nil {
		return false
	}
	return v.Selected != v.All
}
