package transfer

import (
	"sort"

	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	"a.yandex-team.ru/travel/app/backend/internal/avia/search/filtering2/helpers"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/library/go/containers"
)

func buildInitialDirectionAirportsResponse(
	directionAirports containers.Set[uint64],
	selectedDirectionAirports containers.Set[uint64],
	reference *aviaSearchProto.Reference,
) []*aviaAPI.SearchFiltersRsp_TransferAirport {
	if len(directionAirports) == 0 {
		return nil
	}

	settlementCounter := helpers.NewKeyCounter()
	for aID := range directionAirports {
		settlementID := reference.Stations[aID].SettlementId
		if settlementID != 0 {
			settlementCounter.Increment(settlementID)
		}
	}

	direction := make([]*aviaAPI.SearchFiltersRsp_TransferAirport, 0, len(directionAirports))
	for id := range directionAirports {
		station := reference.Stations[id]
		a := &aviaAPI.SearchFiltersRsp_TransferAirport{
			StationId: id,
			State: &aviaAPI.SearchFiltersRsp_BoolFilterState{
				Enabled: true,
				Value:   selectedDirectionAirports.Contains(id),
			},
			StationTitle:    station.Title,
			SettlementTitle: "",
			AviaCode:        station.AviaCode,
		}
		if station.SettlementId != 0 {
			settlementTitle := reference.Settlements[station.SettlementId].Title
			hasOtherStationsInSettlement := settlementCounter.GetCount(station.SettlementId) > 1
			if hasOtherStationsInSettlement || station.Title != settlementTitle {
				a.SettlementTitle = settlementTitle
			}
		}
		direction = append(direction, a)
	}

	sort.SliceStable(direction, func(i, j int) bool {
		return direction[i].StationId < direction[j].StationId
	})

	return direction
}
