package transfer

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	"a.yandex-team.ru/travel/app/backend/internal/avia/search/filtering2/filterinterface"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type NoNightTransferFilter struct {
	selectedAirportsForward  map[uint64]struct{}
	selectedAirportsBackward map[uint64]struct{}
}

func (tf *NoNightTransferFilter) GetFilterID() string {
	return "NoNightTransferFilter"
}

func NewNoNightTransferFilter() *NoNightTransferFilter {
	return &NoNightTransferFilter{}
}

func (tf *NoNightTransferFilter) InitFilterResponse(
	filters *aviaAPI.SearchFiltersReq,
	snippets map[string]*aviaSearchProto.Snippet,
	reference *aviaSearchProto.Reference,
	searchContext *aviaSearchProto.SearchContext,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *aviaAPI.SearchFiltersRsp {
	if filterResponse.Transfer == nil {
		filterResponse.Transfer = &aviaAPI.SearchFiltersRsp_TransferFilter{}
	}

	filterResponse.Transfer.NoNightTransfer = &aviaAPI.SearchFiltersRsp_BoolFilterState{
		Enabled: true,
		Value:   false,
	}
	if filters != nil && filters.Transfer != nil {
		filterResponse.Transfer.NoNightTransfer.Value = filters.Transfer.NoNightTransfer
	}

	return filterResponse
}

func (tf *NoNightTransferFilter) needToSkip(filterResponse *aviaAPI.SearchFiltersRsp, transfers *aviaSearchProto.Transfers) bool {
	for _, t := range transfers.ForwardTransfers {
		if t.NightTransfer && filterResponse.Transfer.NoNightTransfer.Value {
			return true
		}
	}
	for _, t := range transfers.BackwardTransfers {
		if t.NightTransfer && filterResponse.Transfer.NoNightTransfer.Value {
			return true
		}
	}
	return false
}

func (tf *NoNightTransferFilter) Filter(
	filters *aviaAPI.SearchFiltersReq,
	snippets map[string]*aviaSearchProto.Snippet,
	reference *aviaSearchProto.Reference,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *filterinterface.ExcludedKeys {
	excludedKeys := filterinterface.NewExcludedKeys()
	for sKey, s := range snippets {
		if tf.needToSkip(filterResponse, s.Transfers) {
			excludedKeys.AddSnippetKey(sKey)
		}
	}
	return excludedKeys
}

func (tf *NoNightTransferFilter) UpdateFilterResponse(
	snippets map[string]*aviaSearchProto.Snippet,
	excludedKeysByOthers *filterinterface.ExcludedKeys,
	reference *aviaSearchProto.Reference,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *aviaAPI.SearchFiltersRsp {
	hasTransferVariantWithoutNightTransfer := false
	for sKey, s := range snippets {
		needToSkip := excludedKeysByOthers.ContainsSnippetKey(sKey)
		if needToSkip {
			continue
		}
		if noNightTransfer(s) {
			hasTransferVariantWithoutNightTransfer = true
			break
		}
	}

	filterResponse.Transfer.NoNightTransfer.Enabled = hasTransferVariantWithoutNightTransfer

	return filterResponse
}

func noNightTransfer(s *aviaSearchProto.Snippet) bool {
	if len(s.Transfers.ForwardTransfers) == 0 && len(s.Transfers.BackwardTransfers) == 0 {
		// Нет пересадок - значит нет и ночных пересадок
		return true
	}

	for _, t := range s.Transfers.ForwardTransfers {
		if t.NightTransfer {
			return false
		}
	}
	for _, t := range s.Transfers.BackwardTransfers {
		if t.NightTransfer {
			return false
		}
	}
	return true
}
