package transfer

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	"a.yandex-team.ru/travel/app/backend/internal/avia/search/filtering2/filterinterface"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type OneTransferOrLess struct {
	selectedAirportsForward  map[uint64]struct{}
	selectedAirportsBackward map[uint64]struct{}
}

func (tf *OneTransferOrLess) GetFilterID() string {
	return "OneTransferOrLessFilter"
}

func NewOneTransferOrLess() *OneTransferOrLess {
	return &OneTransferOrLess{}
}

func (tf *OneTransferOrLess) InitFilterResponse(
	filters *aviaAPI.SearchFiltersReq,
	snippets map[string]*aviaSearchProto.Snippet,
	reference *aviaSearchProto.Reference,
	searchContext *aviaSearchProto.SearchContext,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *aviaAPI.SearchFiltersRsp {
	if filterResponse.Transfer == nil {
		filterResponse.Transfer = &aviaAPI.SearchFiltersRsp_TransferFilter{}
	}

	f := &aviaAPI.SearchFiltersRsp_BoolFilterState{
		Enabled: true,
		Value:   false,
	}
	if filters != nil && filters.Transfer != nil {
		f.Value = filters.Transfer.OneTransferOrLess
	}
	filterResponse.Transfer.OneTransferOrLess = f

	return filterResponse
}

func (tf *OneTransferOrLess) needToSkip(filterResponse *aviaAPI.SearchFiltersRsp, transfers *aviaSearchProto.Transfers) bool {
	if filterResponse.Transfer.OneTransferOrLess.Value && (len(transfers.ForwardTransfers) > 1 || len(transfers.BackwardTransfers) > 1) {
		return true
	}
	return false
}

func (tf *OneTransferOrLess) Filter(
	filters *aviaAPI.SearchFiltersReq,
	snippets map[string]*aviaSearchProto.Snippet,
	reference *aviaSearchProto.Reference,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *filterinterface.ExcludedKeys {
	excludedKeys := filterinterface.NewExcludedKeys()
	for sKey, s := range snippets {
		if tf.needToSkip(filterResponse, s.Transfers) {
			excludedKeys.AddSnippetKey(sKey)
		}
	}
	return excludedKeys
}

func (tf *OneTransferOrLess) UpdateFilterResponse(
	snippets map[string]*aviaSearchProto.Snippet,
	excludedKeysByOthers *filterinterface.ExcludedKeys,
	reference *aviaSearchProto.Reference,
	filterResponse *aviaAPI.SearchFiltersRsp,
) *aviaAPI.SearchFiltersRsp {
	hasOneOrLessTransfer := false
	for sKey, s := range snippets {
		needToSkip := excludedKeysByOthers.ContainsSnippetKey(sKey)
		if needToSkip {
			continue
		}
		if len(s.Transfers.ForwardTransfers) <= 1 && len(s.Transfers.BackwardTransfers) <= 1 {
			hasOneOrLessTransfer = true
			break
		}
	}

	filterResponse.Transfer.OneTransferOrLess.Enabled = hasOneOrLessTransfer

	return filterResponse
}
