package factories

import (
	"strconv"

	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type AllianceOption func(*aviaSearchProto.Alliance) *aviaSearchProto.Alliance

func CreateAlliance(id uint64, opts ...AllianceOption) *aviaSearchProto.Alliance {
	strID := strconv.FormatInt(int64(id), 10)
	a := &aviaSearchProto.Alliance{
		Id:    id,
		Title: "Альянс" + strID,
	}
	for _, opt := range opts {
		opt(a)
	}
	return a
}
