package factories

import (
	"strconv"

	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type AviaCompanyOption func(*aviaSearchProto.AviaCompany) *aviaSearchProto.AviaCompany

func CreateAviaCompany(id uint64, opts ...AviaCompanyOption) *aviaSearchProto.AviaCompany {
	strID := strconv.FormatInt(int64(id), 10)
	ac := &aviaSearchProto.AviaCompany{
		Id:         id,
		AllianceId: 0,
		Title:      "Авиакомпания" + strID,
		LogoSvg:    "https://example.com/" + strID + ".svg",
		LogoPng:    "https://example.com/" + strID + ".png",
		Color:      "#aa9900",
	}
	for _, opt := range opts {
		opt(ac)
	}
	return ac
}

func WithAlliance(alliance *aviaSearchProto.Alliance) AviaCompanyOption {
	return func(ac *aviaSearchProto.AviaCompany) *aviaSearchProto.AviaCompany {
		ac.AllianceId = alliance.Id
		return ac
	}
}
