package factories

import (
	"fmt"
	"strconv"
	"strings"
	"time"

	timeformats "cuelang.org/go/pkg/time"
	"google.golang.org/protobuf/types/known/timestamppb"

	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type CreateFlightOption func(*aviaSearchProto.Flight) *aviaSearchProto.Flight

func CreateFlight(
	ac *aviaSearchProto.AviaCompany,
	number string,
	from *aviaSearchProto.Station,
	to *aviaSearchProto.Station,
	da string, // departure & arrival, пример "9:30 - 11:40"
	opts ...CreateFlightOption,
) *aviaSearchProto.Flight {
	flight := &aviaSearchProto.Flight{
		Key:           "",
		AviaCompanyId: ac.Id,
		Number:        number,
		StationFromId: from.Id,
		StationToId:   to.Id,
	}

	daSplited := strings.Split(da, " ")
	departure := daSplited[0]
	arrival := daSplited[2]
	departureHM := strings.Split(departure, ":")
	arrivalHM := strings.Split(arrival, ":")
	dHours, _ := strconv.Atoi(departureHM[0])
	dMinutes, _ := strconv.Atoi(departureHM[1])
	aHours, _ := strconv.Atoi(arrivalHM[0])
	aMinutes, _ := strconv.Atoi(arrivalHM[1])
	dStr := fmt.Sprintf("2022-04-26T%.2d:%.2d:00+03:00", dHours, dMinutes)
	aStr := fmt.Sprintf("2022-04-26T%.2d:%.2d:00+03:00", aHours, aMinutes)
	d, _ := time.Parse(timeformats.RFC3339, dStr)
	a, _ := time.Parse(timeformats.RFC3339, aStr)

	for !d.Before(a) {
		a = a.AddDate(0, 0, 1)
	}
	aStr = a.Format(timeformats.RFC3339)

	flight.Departure = timestamppb.New(d)
	flight.DepartureStr = dStr
	flight.Arrival = timestamppb.New(a)
	flight.ArrivalStr = aStr
	flight.DurationMinutes = uint32(a.Sub(d).Minutes())

	joinedNumber := strings.Join(strings.Fields(number), "")
	flight.Key = fmt.Sprintf("%s%s%s", d.Format("0601021504"), joinedNumber, a.Format("0601021504"))

	for _, opt := range opts {
		flight = opt(flight)
	}

	return flight
}

func WithDepartureDayShift(departureDayShift uint) CreateFlightOption {
	return func(flight *aviaSearchProto.Flight) *aviaSearchProto.Flight {
		// Сначала добавим нужное количество дней для отправления
		d, _ := time.Parse(timeformats.RFC3339, flight.DepartureStr)
		d = d.AddDate(0, 0, int(departureDayShift))
		flight.Departure = timestamppb.New(d)
		flight.DepartureStr = d.Format(timeformats.RFC3339)

		// Теперь поправим прибытие
		a, _ := time.Parse(timeformats.RFC3339, flight.ArrivalStr)
		for !d.Before(a) {
			a = a.AddDate(0, 0, 1)
		}
		flight.Arrival = timestamppb.New(a)
		flight.ArrivalStr = a.Format(timeformats.RFC3339)

		return flight
	}
}
