package factories

import (
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type CreatePartnerOption func(*aviaSearchProto.Partner) *aviaSearchProto.Partner

func CreatePartner(code string, opts ...CreatePartnerOption) *aviaSearchProto.Partner {
	partner := &aviaSearchProto.Partner{
		Code:    code,
		Title:   "Партнер " + code,
		LogoSvg: "https://example.net/" + code + ".svg",
		LogoPng: "https://example.net/" + code + ".png",
	}

	for _, opt := range opts {
		partner = opt(partner)
	}

	return partner
}
