package factories

import aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"

func (r *Reference) CreateMoscow() *aviaSearchProto.Settlement {
	msk := &aviaSearchProto.Settlement{
		Id:               213,
		Title:            "Москва",
		TitleGenitive:    "Москвы",
		TitleAccusative:  "Москву",
		TitleLocative:    "Москве",
		TitlePreposition: "в",
	}
	r.AddSettlement(msk)
	return msk
}

func (r *Reference) CreateSheremetyevo(msk *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	svo := &aviaSearchProto.Station{
		Id:               9600213,
		AviaCode:         "SVO",
		SettlementId:     msk.Id,
		Title:            "Шереметьево",
		TitleGenitive:    "Шереметьева",
		TitleAccusative:  "Шереметьево",
		TitlePreposition: "в",
		TitleLocative:    "Шереметьеве",
	}
	r.AddStation(svo)
	return svo
}

func (r *Reference) CreateVnukovo(msk *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	svo := &aviaSearchProto.Station{
		Id:               9600215,
		AviaCode:         "VKO",
		SettlementId:     msk.Id,
		Title:            "Внуково",
		TitleGenitive:    "Внуково",
		TitleAccusative:  "Внуково",
		TitlePreposition: "в",
		TitleLocative:    "Внуково",
	}
	r.AddStation(svo)
	return svo
}

func (r *Reference) CreateDomodedovo(msk *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	svo := &aviaSearchProto.Station{
		Id:               9600216,
		AviaCode:         "DME",
		SettlementId:     msk.Id,
		Title:            "Домодедово",
		TitleGenitive:    "Домодедово",
		TitleAccusative:  "Домодедово",
		TitlePreposition: "в",
		TitleLocative:    "Домодедово",
	}
	r.AddStation(svo)
	return svo
}

func (r *Reference) CreateBlagoveschinsk() *aviaSearchProto.Settlement {
	bg := &aviaSearchProto.Settlement{
		Id:               77,
		Title:            "Благовещенск",
		TitleGenitive:    "Благовещенска",
		TitleAccusative:  "Благовещенск",
		TitleLocative:    "Благовещенске",
		TitlePreposition: "в",
	}
	r.AddSettlement(bg)
	return bg
}

func (r *Reference) CreateBlagoveschinskAirport(blagoveschinsk *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	a := &aviaSearchProto.Station{
		Id:               9623271,
		AviaCode:         "BQS",
		SettlementId:     blagoveschinsk.Id,
		Title:            "Благовещенск",
		TitleGenitive:    "Благовещенска",
		TitleAccusative:  "Благовещенск",
		TitlePreposition: "в",
		TitleLocative:    "Благовещенске",
	}
	r.AddStation(a)
	return a
}

func (r *Reference) CreateZea() *aviaSearchProto.Settlement {
	zea := &aviaSearchProto.Settlement{
		Id:               11379,
		Title:            "Зея",
		TitleGenitive:    "Зеи",
		TitleAccusative:  "Зею",
		TitleLocative:    "Зее",
		TitlePreposition: "в",
	}
	r.AddSettlement(zea)
	return zea
}

func (r *Reference) CreateZeaAirport(zea *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	a := &aviaSearchProto.Station{
		Id:               9635355,
		AviaCode:         "ЗЕЯ",
		SettlementId:     zea.Id,
		Title:            "Зея",
		TitleGenitive:    "Зеи",
		TitleAccusative:  "Зею",
		TitlePreposition: "в",
		TitleLocative:    "Зее",
	}
	r.AddStation(a)
	return a
}

func (r *Reference) CreateYekaterinburg() *aviaSearchProto.Settlement {
	ekb := &aviaSearchProto.Settlement{
		Id:               54,
		Title:            "Екатеринбург",
		TitleGenitive:    "Екатеринбурга",
		TitleAccusative:  "Екатеринбург",
		TitleLocative:    "Екатеринбурге",
		TitlePreposition: "в",
	}
	r.AddSettlement(ekb)
	return ekb
}

func (r *Reference) CreateKoltsovo(yekaterinburg *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	a := &aviaSearchProto.Station{
		Id:               9600370,
		AviaCode:         "SVX",
		SettlementId:     yekaterinburg.Id,
		Title:            "Кольцово",
		TitleGenitive:    "Кольцово",
		TitleAccusative:  "Кольцово",
		TitlePreposition: "в",
		TitleLocative:    "Кольцово",
	}
	r.AddStation(a)
	return a
}

func (r *Reference) CreateZhukovskiy() *aviaSearchProto.Settlement {
	z := &aviaSearchProto.Settlement{
		Id:               20571,
		Title:            "Жуковский",
		TitleGenitive:    "Жуковского",
		TitleAccusative:  "Жуковский",
		TitleLocative:    "Жуковском",
		TitlePreposition: "в",
	}
	r.AddSettlement(z)
	return z
}

func (r *Reference) CreateZhukovskiyAirport(zhukovskiy *aviaSearchProto.Settlement) *aviaSearchProto.Station {
	a := &aviaSearchProto.Station{
		Id:               9850865,
		AviaCode:         "ZIA",
		SettlementId:     zhukovskiy.Id,
		Title:            "Жуковский",
		TitleGenitive:    "Жуковского",
		TitleAccusative:  "Жуковский",
		TitleLocative:    "Жуковском",
		TitlePreposition: "в",
	}
	r.AddStation(a)
	return a
}
