package factories

import (
	"strconv"

	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type CreateSettlementOption func(*aviaSearchProto.Settlement) *aviaSearchProto.Settlement

func CreateSettlement(id uint64, opts ...CreateSettlementOption) *aviaSearchProto.Settlement {
	strID := strconv.FormatInt(int64(id), 10)

	settlement := &aviaSearchProto.Settlement{
		Id:               id,
		Title:            "Город " + strID,
		TitleGenitive:    "Города " + strID,
		TitleAccusative:  "Город " + strID,
		TitleLocative:    "Городе " + strID,
		TitlePreposition: "в",
	}

	return settlement
}
