package factories

import (
	"strconv"

	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type CreateStationOption func(*aviaSearchProto.Station) *aviaSearchProto.Station

func CreateStation(id uint64, opts ...CreateStationOption) *aviaSearchProto.Station {
	strID := strconv.FormatInt(int64(id), 10)

	station := &aviaSearchProto.Station{
		Id:               id,
		AviaCode:         "",
		SettlementId:     0,
		Title:            "Станция " + strID,
		TitleGenitive:    "Станции " + strID,
		TitleAccusative:  "Станцию " + strID,
		TitleLocative:    "Станции " + strID,
		TitlePreposition: "на",
	}

	for _, opt := range opts {
		station = opt(station)
	}

	return station
}

func WithSettlement(settlement *aviaSearchProto.Settlement) CreateStationOption {
	return func(station *aviaSearchProto.Station) *aviaSearchProto.Station {
		station.SettlementId = settlement.Id
		return station
	}
}

func StationWithAviaCode(aviaCode string) CreateStationOption {
	return func(station *aviaSearchProto.Station) *aviaSearchProto.Station {
		station.AviaCode = aviaCode
		return station
	}
}
