package factories

import (
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	aviaProtoV2 "a.yandex-team.ru/travel/avia/library/proto/common/v2"
)

type CreateVariantOption func(*aviaSearchProto.Variant) *aviaSearchProto.Variant

func CreateVariant(key string, partner *aviaSearchProto.Partner, opts ...CreateVariantOption) *aviaSearchProto.Variant {
	variant := &aviaSearchProto.Variant{
		Key:         key,
		PartnerCode: partner.Code,
		Price: &aviaProtoV2.Price{
			Currency: "RUB",
			Value:    12345,
		},
		Baggage: &aviaSearchProto.Baggage{
			Included:       false,
			OptionalWeight: nil,
			OptionalPieces: nil,
		},
		CarryOn: &aviaSearchProto.CarryOn{
			Included:       false,
			OptionalWeight: nil,
		},
		Refund: &aviaSearchProto.Refund{
			Availability: aviaSearchProto.RefundAvailability_REFUND_AVAILABILITY_NOT_AVAILABLE,
			Charge:       nil,
		},
		OrderRelativeUrl: "/avia/order/?adult_seats=1&children_seats=0&forward=HZ+5582.2022-04-26T19%3A10&fromId=c77&infant_seats=0&klass=economy&oneway=1&toId=c11379&when=2022-04-26",
	}

	for _, opt := range opts {
		variant = opt(variant)
	}

	return variant
}

func WithPrice(price *aviaProtoV2.Price) CreateVariantOption {
	return func(variant *aviaSearchProto.Variant) *aviaSearchProto.Variant {
		variant.Price = &aviaProtoV2.Price{
			Currency: price.Currency,
			Value:    price.Value,
		}
		return variant
	}
}

func WithPriceRUB(price float64) CreateVariantOption {
	return func(variant *aviaSearchProto.Variant) *aviaSearchProto.Variant {
		variant.Price = &aviaProtoV2.Price{
			Currency: "RUB",
			Value:    price,
		}
		return variant
	}
}

func WithBaggage(weight, pieces uint32) CreateVariantOption {
	return func(variant *aviaSearchProto.Variant) *aviaSearchProto.Variant {
		variant.Baggage = &aviaSearchProto.Baggage{
			Included:       true,
			OptionalWeight: &aviaSearchProto.Baggage_Weight{Weight: weight},
			OptionalPieces: &aviaSearchProto.Baggage_Pieces{Pieces: pieces},
		}
		return variant
	}
}
