package searchcommon

import (
	commonAPI "a.yandex-team.ru/travel/app/backend/api/common/v1"
	v1 "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

const (
	comparationEqual   = iota
	comparationLower   = iota
	comparationGreater = iota
)

func compareByFlightsLen(left, right []string) int {
	leftLen := len(left)
	rightLen := len(right)

	if leftLen == 0 {
		if rightLen != 0 {
			return comparationLower
		}
	} else {
		if rightLen == 0 {
			return comparationGreater
		}
	}

	return comparationEqual
}

func compareDeparture(left, right []string, flights map[string]*v1.Flight) int {
	preRes := compareByFlightsLen(left, right)
	if preRes != comparationEqual {
		return preRes
	}
	if len(left) == 0 && len(right) == 0 {
		return comparationEqual
	}

	leftFirstForwardFlight := flights[left[0]]
	rightFirstForwardFlight := flights[right[0]]
	if leftFirstForwardFlight.Departure.Seconds < rightFirstForwardFlight.Departure.Seconds {
		return comparationLower
	} else if leftFirstForwardFlight.Departure.Seconds > rightFirstForwardFlight.Departure.Seconds {
		return comparationGreater
	} else {
		return comparationEqual
	}
}

func compareArrival(left, right []string, flights map[string]*v1.Flight) int {
	preRes := compareByFlightsLen(left, right)
	if preRes != comparationEqual {
		return preRes
	}
	if len(left) == 0 && len(right) == 0 {
		return comparationEqual
	}

	leftFirstForwardFlight := flights[left[0]]
	rightFirstForwardFlight := flights[right[0]]
	if leftFirstForwardFlight.Arrival.Seconds < rightFirstForwardFlight.Arrival.Seconds {
		return comparationLower
	} else if leftFirstForwardFlight.Arrival.Seconds > rightFirstForwardFlight.Arrival.Seconds {
		return comparationGreater
	} else {
		return comparationEqual
	}
}

func compareFlights(
	leftForward, rightForward, leftBackward, rightBackward []string,
	flights map[string]*v1.Flight,
) int {
	compareResult := compareDeparture(leftForward, rightForward, flights)
	if compareResult != comparationEqual {
		return compareResult
	}

	compareResult = compareDeparture(leftBackward, rightBackward, flights)
	if compareResult != comparationEqual {
		return compareResult
	}

	compareResult = compareArrival(leftForward, rightForward, flights)
	if compareResult != comparationEqual {
		return compareResult
	}

	compareResult = compareArrival(leftBackward, rightBackward, flights)
	if compareResult != comparationEqual {
		return compareResult
	}

	return comparationEqual
}

func compareOnlyPriceAsc(left, right *commonAPI.Price) int {
	if left.Currency == right.Currency {
		if left.Value < right.Value {
			return comparationLower
		} else if left.Value > right.Value {
			return comparationGreater
		} else {
			return comparationEqual
		}
	} else {
		if left.Currency == "RUB" {
			return comparationLower
		} else if right.Currency == "RUB" {
			return comparationGreater
		} else {
			return comparationEqual
		}
	}
}

func compareOnlyPriceDesc(left, right *commonAPI.Price) int {
	if left.Currency == right.Currency {
		if left.Value > right.Value {
			return comparationLower
		} else if left.Value < right.Value {
			return comparationGreater
		} else {
			return comparationEqual
		}
	} else {
		if left.Currency == "RUB" {
			return comparationLower
		} else if right.Currency == "RUB" {
			return comparationGreater
		} else {
			return comparationEqual
		}
	}
}

func compareExtendedPriceAsc(
	leftPrice, rightPrice *commonAPI.Price,
	leftForward, rightForward, leftBackward, rightBackward []string,
	flights map[string]*v1.Flight,
) int {
	compareResult := compareOnlyPriceAsc(leftPrice, rightPrice)
	if compareResult != comparationEqual {
		return compareResult
	}

	return compareFlights(leftForward, rightForward, leftBackward, rightBackward, flights)
}

func compareExtendedPriceDesc(
	leftPrice, rightPrice *commonAPI.Price,
	leftForward, rightForward, leftBackward, rightBackward []string,
	flights map[string]*v1.Flight,
) int {
	compareResult := compareOnlyPriceDesc(leftPrice, rightPrice)
	if compareResult != comparationEqual {
		return compareResult
	}

	return compareFlights(leftForward, rightForward, leftBackward, rightBackward, flights)
}

func CompareOnlyPriceAsc(leftPrice, rightPrice *commonAPI.Price) bool {
	result := compareOnlyPriceAsc(leftPrice, rightPrice)
	if result == comparationLower {
		return true
	} else if result == comparationGreater {
		return false
	} else {
		return true
	}
}

func CompareExtendedPriceAsc(leftPrice, rightPrice *commonAPI.Price,
	leftForward, rightForward, leftBackward, rightBackward []string,
	flights map[string]*v1.Flight,
) bool {
	result := compareExtendedPriceAsc(leftPrice, rightPrice, leftForward, rightForward, leftBackward, rightBackward, flights)
	if result == comparationLower {
		return true
	} else if result == comparationGreater {
		return false
	} else {
		return true
	}
}

func CompareExtendedPriceDesc(leftPrice, rightPrice *commonAPI.Price,
	leftForward, rightForward, leftBackward, rightBackward []string,
	flights map[string]*v1.Flight,
) bool {
	result := compareExtendedPriceDesc(leftPrice, rightPrice, leftForward, rightForward, leftBackward, rightBackward, flights)
	if result == comparationLower {
		return true
	} else if result == comparationGreater {
		return false
	} else {
		return true
	}
}

func CheckOnlyPriceEqual(left, right *commonAPI.Price) bool {
	return left.Value == right.Value && left.Currency == right.Currency
}
