package calendar

import (
	"time"

	"a.yandex-team.ru/travel/library/go/geobase/consts"
)

type Config struct {
	RequestTimeout  time.Duration `yaml:"request_timeout"`
	CachingInterval time.Duration `yaml:"caching_interval"`
	RetryInterval   time.Duration `yaml:"retry_interval"`
}

var DefaultConfig = Config{
	RequestTimeout:  5 * time.Second,
	RetryInterval:   30 * time.Second,
	CachingInterval: consts.Day,
}
