package cityimages

import (
	"time"
)

type Config struct {
	RequestTimeout   time.Duration `yaml:"request_timeout"`
	CachingInterval  time.Duration `yaml:"caching_interval"`
	FetchingInterval time.Duration `yaml:"fetching_interval"`
	DefaultCityImage string
}

var DefaultConfig = Config{
	RequestTimeout:   2 * time.Second,
	CachingInterval:  time.Hour,
	FetchingInterval: 2 * time.Second,
	DefaultCityImage: "https://avatars.mds.yandex.net/get-travel-app/6433113/2a0000018097994a79819dd06f1e6cb5ceef/orig",
}
