package common

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/grpc-ecosystem/go-grpc-middleware/logging/zap/ctxzap"
	"go.uber.org/zap"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"

	"a.yandex-team.ru/travel/avia/library/go/services/featureflag"
	"a.yandex-team.ru/travel/library/go/containers"
)

const AviaFiltersDisableOnlyFlag = "TRAVELAPP_AVIA_FILTERS_DISABLE_ONLY"

type abExperiments struct {
	AviaFiltersDisableOnly *string `json:"TRAVELAPP_AVIA_FILTERS_DISABLE_ONLY"`
}

func (ab *abExperiments) getABFlags() containers.Set[string] {
	result := containers.Set[string]{}
	if ab.AviaFiltersDisableOnly != nil && *ab.AviaFiltersDisableOnly == "1" {
		result.Add(AviaFiltersDisableOnlyFlag)
	}
	return result
}

func getABExperiments(ctx context.Context) *abExperiments {
	ab := &abExperiments{}
	if md, ok := metadata.FromIncomingContext(ctx); ok {
		if h, ok := md[ABExperimentsGrpcHeader]; ok {
			jsonAB := h[0]
			err := json.Unmarshal([]byte(jsonAB), &ab)
			if err != nil {
				ctxzap.Extract(ctx).Error(fmt.Sprintf("unsupported value in header %s", ABExperimentsGrpcHeader),
					zap.String("raw value", jsonAB))
			}
		}
	}
	return ab
}

func NewABInterceptor() grpc.UnaryServerInterceptor {
	return func(
		ctx context.Context,
		req interface{},
		info *grpc.UnaryServerInfo,
		handler grpc.UnaryHandler,
	) (interface{}, error) {
		ctx = featureflag.WithABFlags(ctx, getABExperiments(ctx).getABFlags().Values()...)

		resp, err := handler(ctx, req)

		return resp, err
	}
}
