package common

const ServiceName = "travelapp"

type OSType int

const (
	OSTypeUnknown OSType = iota
	OSTypeIOS
	OSTypeAndroid
)

var osTypeByName = map[string]OSType{
	"ios":     OSTypeIOS,
	"android": OSTypeAndroid,
}

var osTypeNames map[OSType]string

var ppCodeByOsType = map[OSType]int{
	OSTypeIOS:     513,
	OSTypeAndroid: 514,
}

func init() {
	osTypeNames = make(map[OSType]string)
	for key, value := range osTypeByName {
		osTypeNames[value] = key
	}
}

func (t OSType) Name() string {
	return osTypeNames[t]
}

func (t OSType) Pp() (int, bool) {
	pp, exists := ppCodeByOsType[t]
	return pp, exists
}
