package common

import (
	"fmt"
	"time"

	timeformats "cuelang.org/go/pkg/time"
	"google.golang.org/genproto/googleapis/type/date"
)

// Форматируем время согласно договоренностям https://wiki.yandex-team.ru/travel/app/dev/#data-vremjasuchetomtajjmzony
func FormatISO8601(t time.Time) string {
	return t.Format("2006-01-02T15:04:05-07:00")
}

func FormatDateProto(d *date.Date) string {
	if d == nil {
		return ""
	}
	return fmt.Sprintf("%4d-%02d-%02d", d.Year, d.Month, d.Day)
}

func DateStringToProto(dateStr string) (*date.Date, error) {
	if dateStr == "" {
		return nil, nil
	}
	t, err := ParseDate(dateStr)
	if err != nil {
		return nil, err
	}
	return &date.Date{
		Year:  int32(t.Year()),
		Month: int32(t.Month()),
		Day:   int32(t.Day()),
	}, nil
}

func FormatDate(t time.Time) string {
	return t.Format(timeformats.RFC3339Date)
}

func ParseDate(dateStr string) (time.Time, error) {
	return time.Parse(timeformats.RFC3339Date, dateStr)
}
