package common

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	commonAPI "a.yandex-team.ru/travel/app/backend/api/common/v1"
)

func GetPointType(pointKey string) (commonAPI.GeoPointType, error) {
	if pointKey == "" {
		return commonAPI.GeoPointType_GEO_POINT_TYPE_INVALID, xerrors.Errorf("empty pointKey")
	}
	switch pointKey[0] {
	case 'l':
		return commonAPI.GeoPointType_GEO_POINT_TYPE_COUNTRY, nil
	case 'r':
		return commonAPI.GeoPointType_GEO_POINT_TYPE_REGION, nil
	case 'c':
		return commonAPI.GeoPointType_GEO_POINT_TYPE_SETTLEMENT, nil
	case 's':
		return commonAPI.GeoPointType_GEO_POINT_TYPE_STATION, nil
	}

	return commonAPI.GeoPointType_GEO_POINT_TYPE_INVALID, xerrors.Errorf("invalid pointKey '%s'", pointKey)
}
