package common

import commonAPI "a.yandex-team.ru/travel/app/backend/api/commonorder/v1"

var FinalStatuses = map[commonAPI.OrderStatus]struct{}{
	commonAPI.OrderStatus_ORDER_STATUS_SUCCESS:   {},
	commonAPI.OrderStatus_ORDER_STATUS_CANCELLED: {},
	commonAPI.OrderStatus_ORDER_STATUS_FAILED:    {},
}

func BuildFinalStatus(status *commonAPI.OrderStatus) commonAPI.HappyPageFinalStatus {
	switch *status {
	case commonAPI.OrderStatus_ORDER_STATUS_SUCCESS:
		return commonAPI.HappyPageFinalStatus_HAPPY_PAGE_FINAL_STATUS_SUCCESS
	case commonAPI.OrderStatus_ORDER_STATUS_CANCELLED:
		return commonAPI.HappyPageFinalStatus_HAPPY_PAGE_FINAL_STATUS_BOOKING_CANCELLED
	case commonAPI.OrderStatus_ORDER_STATUS_PAYMENT_FAILED:
		return commonAPI.HappyPageFinalStatus_HAPPY_PAGE_FINAL_STATUS_PAYMENT_FAILED
	case commonAPI.OrderStatus_ORDER_STATUS_FAILED:
		return commonAPI.HappyPageFinalStatus_HAPPY_PAGE_FINAL_STATUS_UNKNOWN_ERROR
	}
	return commonAPI.HappyPageFinalStatus_HAPPY_PAGE_FINAL_STATUS_UNKNOWN_ERROR
}
