package common

import (
	"fmt"
	"net/url"

	"github.com/golang/protobuf/ptypes/wrappers"
)

func GetTokenFromURL(paymentURL *string, key string) (*wrappers.StringValue, error) {
	if paymentURL == nil || *paymentURL == "" {
		return nil, nil
	}
	parsedURL, err := url.Parse(*paymentURL)
	if err != nil {
		return nil, fmt.Errorf("invalid payment url")
	}
	values, err := url.ParseQuery(parsedURL.RawQuery)
	if err != nil {
		return nil, fmt.Errorf("invalid payment url")
	}
	pt := values.Get(key)
	if pt != "" {
		return &wrappers.StringValue{Value: pt}, nil
	} else {
		return nil, fmt.Errorf("payment url without %s", key)
	}
}
