package common

import (
	"context"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

var NoTvmServiceTicketError = xerrors.NewSentinel("no service ticket")

const serviceTicketHeader = "X-Ya-Service-Ticket"

func GetTVMHeaderProvider(tvmClient tvm.Client, destination string) HeaderProvider {
	return func(ctx context.Context) (map[string]string, error) {
		serviceTicket, err := tvmClient.GetServiceTicketForAlias(ctx, destination)
		if err != nil {
			return nil, NoTvmServiceTicketError.Wrap(err)
		}
		return map[string]string{
			serviceTicketHeader: serviceTicket,
		}, nil
	}
}
