package handler

import (
	"net/http"
	"net/url"
	"strconv"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/travel/app/backend/internal/healthswitch"
	"a.yandex-team.ru/travel/library/go/httputil"
)

type HTTPHealthSwitchHandler struct {
	sw *healthswitch.Switch
}

func NewHTTPHealthSwitchHandler(sw *healthswitch.Switch) *HTTPHealthSwitchHandler {
	return &HTTPHealthSwitchHandler{sw: sw}
}

func (h *HTTPHealthSwitchHandler) SetHealth(w http.ResponseWriter, r *http.Request) {
	params, err := url.ParseQuery(r.URL.RawQuery)
	if err != nil {
		httputil.HandleError(err, http.StatusBadRequest, w)
		return
	}

	health := params.Get("health")
	s, err := strconv.ParseBool(health)
	if err != nil {
		httputil.HandleError(err, http.StatusBadRequest, w)
		return
	}

	h.sw.SetHealth(s)
	w.WriteHeader(http.StatusOK)
	w.Header().Set("Content-Type", "application/json")
	_, _ = w.Write([]byte("Ok"))
}

func (h *HTTPHealthSwitchHandler) GetRouteBuilder() func(r chi.Router) {
	return func(r chi.Router) {
		r.Get("/health", h.SetHealth)
	}
}
