package hotels

type Config struct {
	SuggestLimit     uint32 `yaml:"suggests_limit"`
	ImagesLimit      uint32 `yaml:"images_limit"`
	ImageSizeDefault string
	HotelsLimit      uint32 `yaml:"hotels_limit"`
	Order            OrderConfig
	Favorites        FavoritesConfig
	Reviews          ReviewsConfig
	HotelInfo        HotelInfo
}

type HotelInfo struct {
	ReviewLimit  uint32
	PhraseLimit  uint32
	ImageLimit   uint32
	SimilarLimit uint32
}

type OrderConfig struct {
	HappyPageImageSuccessURL     string
	HappyPageImageFailedURL      string
	HappyPageHotelImageSize      string
	ExpectedActionDefaultDelayMs uint32
}

type FavoritesConfig struct {
	Limit uint32
}

type ReviewsConfig struct {
	ReviewsLimit      uint32
	PhraseLimit       uint32
	AvatarSuffix      string
	AvatarSizeDefault string
	AvatarDefaultURL  string
}

var DefaultConfig = Config{
	SuggestLimit:     500,
	ImagesLimit:      6,
	ImageSizeDefault: "M", //300*169
	HotelsLimit:      50,
	Order: OrderConfig{
		HappyPageImageSuccessURL:     "https://avatars.mds.yandex.net/get-travel-app/6353118/2a000001812a9163c2310e0517fcb41b3073/orig",
		HappyPageImageFailedURL:      "https://avatars.mds.yandex.net/get-travel-app/6353118/2a000001812a9225d6eab7a2e6f95fe39e00/orig",
		HappyPageHotelImageSize:      "M",
		ExpectedActionDefaultDelayMs: 1000,
	},
	Favorites: FavoritesConfig{
		Limit: 100,
	},
	Reviews: ReviewsConfig{
		ReviewsLimit:      10,
		PhraseLimit:       10,
		AvatarSuffix:      "{size}",
		AvatarSizeDefault: "islands-75",
		AvatarDefaultURL:  "https://avatars.mds.yandex.net/get-yapic/islands-75", // TODO(adurnev) будем делать свою или общую использовать?
	},
	HotelInfo: HotelInfo{
		ReviewLimit:  4,
		PhraseLimit:  10,
		ImageLimit:   6,
		SimilarLimit: 0, // TODO(adurnev) чтобы не получать данные из отеля
	},
}
