package handler

import (
	"context"

	"google.golang.org/grpc"

	hotelsAPI "a.yandex-team.ru/travel/app/backend/api/hotels/v1"
	"a.yandex-team.ru/travel/app/backend/internal/hotels"
)

type GRPCHotelsHandler struct {
	Service *hotels.Service
}

/*
func (h *GRPCHotelsHandler) GetHotelOfferInfo(ctx context.Context, req *hotelsAPI.GetHotelOfferInfoReq) (*hotelsAPI.GetHotelOfferInfoRsp, error) {
	panic("implement me")
}
*/
func (h *GRPCHotelsHandler) GetHotelImages(ctx context.Context, req *hotelsAPI.GetHotelImagesReq) (*hotelsAPI.GetHotelImagesRsp, error) {
	return h.Service.GetHotelImages(ctx, req)
}

func (h *GRPCHotelsHandler) GetSimilarHotels(ctx context.Context, req *hotelsAPI.GetSimilarHotelsReq) (*hotelsAPI.GetSimilarHotelsRsp, error) {
	return h.Service.GetSimilarHotels(ctx, req)
}

func (h *GRPCHotelsHandler) GetHotelOffers(ctx context.Context, req *hotelsAPI.GetHotelOffersReq) (*hotelsAPI.GetHotelOffersRsp, error) {
	return h.Service.GetHotelOffers(ctx, req)
}

func (h *GRPCHotelsHandler) HotelsSuggest(ctx context.Context, req *hotelsAPI.HotelsSuggestReq) (*hotelsAPI.HotelsSuggestRsp, error) {
	return h.Service.Suggest(ctx, req)
}

func (h *GRPCHotelsHandler) HotelsSuggest2(ctx context.Context, req *hotelsAPI.HotelsSuggestReq) (*hotelsAPI.HotelsSuggestRsp, error) {
	return h.Service.Suggest(ctx, req)
}

func (h *GRPCHotelsHandler) LogHotelsSuggestSelected(ctx context.Context, req *hotelsAPI.LogHotelsSuggestSelectedReq) (*hotelsAPI.LogHotelsSuggestSelectedRsp, error) {
	if err := h.Service.LogSuggest(ctx, req); err != nil {
		return nil, err
	}
	return &hotelsAPI.LogHotelsSuggestSelectedRsp{}, nil
}

func (h *GRPCHotelsHandler) LogSelectedHotelsSuggest(ctx context.Context, req *hotelsAPI.LogHotelsSuggestSelectedReq) (*hotelsAPI.LogHotelsSuggestSelectedRsp, error) {
	if err := h.Service.LogSuggest(ctx, req); err != nil {
		return nil, err
	}
	return &hotelsAPI.LogHotelsSuggestSelectedRsp{}, nil
}

func (h *GRPCHotelsHandler) SearchHotels(ctx context.Context, req *hotelsAPI.SearchHotelsReq) (*hotelsAPI.SearchHotelsRsp, error) {
	rsp, err := h.Service.SearchHotels(ctx, req)
	if err != nil {
		return nil, err
	}
	return rsp, nil
}

func (h *GRPCHotelsHandler) GetHotelInfo(ctx context.Context, req *hotelsAPI.GetHotelInfoReq) (*hotelsAPI.GetHotelInfoRsp, error) {
	rsp, err := h.Service.GetHotelInfo(ctx, req)
	if err != nil {
		return nil, err
	}
	return rsp, nil
}

func (h *GRPCHotelsHandler) GetHotelOfferInfo(ctx context.Context, req *hotelsAPI.GetHotelOfferInfoReq) (*hotelsAPI.GetHotelOfferInfoRsp, error) {
	//TODO implement me
	panic("implement me")
}

func (h *GRPCHotelsHandler) GetHotelsCounters(ctx context.Context, req *hotelsAPI.GetHotelCountersReq) (*hotelsAPI.GetHotelCountersRsp, error) {
	rsp, err := h.Service.GetHotelCounters(ctx, req)
	if err != nil {
		return nil, err
	}
	return rsp, nil
}

func (h *GRPCHotelsHandler) GetServiceRegisterer() func(*grpc.Server) {
	return func(server *grpc.Server) {
		hotelsAPI.RegisterHotelsAPIServer(server, h)
	}
}
