package aviabackendclient

type ResponseStatus string

const (
	ErrorResponseStatus   ResponseStatus = "error"
	SuccessResponseStatus ResponseStatus = "success"
)

//[{
//    "name":"geoLookup",
//    "params":{"geoId":"10725"},
//    "fields":[{
//       "name":"searchCity",
//       "fields":["id","key","title","geoId"]
//     }]
//}]
type GeoLookupReq []GeoLookupReqElement

type GeoLookupReqElement struct {
	Name   string  `json:"name"`
	Params Params  `json:"params"`
	Fields []Field `json:"fields"`
}

type Params struct {
	GeoID int32 `json:"geoId"`
}

type Field struct {
	Name   string   `json:"name"`
	Fields []string `json:"fields"`
}

func BuildGeoLookupReq(geoID int32) GeoLookupReq {
	return []GeoLookupReqElement{
		{
			Name:   "geoLookup",
			Params: Params{GeoID: geoID},
			Fields: []Field{
				{
					Name:   "searchCity",
					Fields: []string{"id", "key", "title", "geoId", "code", "iataCode", "sirenaCode"},
				},
			},
		},
	}
}

// {"status":"success","data":[{"searchCity":{"title":"Москва","geoId":213,"key":"c213","id":213}}]}
type GeoLookupRsp struct {
	Status ResponseStatus `json:"status"`
	Data   ResponseData   `json:"data"`
}

type ResponseData []ResponseDataElement

type ResponseDataElement struct {
	SearchCity SearchCityResult `json:"searchCity"`
}

type SearchCityResult struct {
	Title      string `json:"title"`
	GeoID      int32  `json:"geoId"`
	Key        string `json:"key"`
	ID         uint64 `json:"id"`
	Code       string `json:"code"`
	IATACode   string `json:"iataCode"`
	SirenaCode string `json:"sirenaCode"`
}

type TopFlightsReqElement struct {
	Name   string              `json:"name"`
	Params TopFlightsReqParams `json:"params"`
}

type TopFlightsReqParams struct {
	FromKey string `json:"fromKey"`
	ToKey   string `json:"toKey"`
	Date    string `json:"date"`
	Limit   int    `json:"limit"`
}

func BuildTopFlightsReq(fromKey, toKey, date string, limit int) []TopFlightsReqElement {
	return []TopFlightsReqElement{
		{
			Name: "topFlights",
			Params: TopFlightsReqParams{
				FromKey: fromKey,
				ToKey:   toKey,
				Date:    date,
				Limit:   limit,
			},
		},
	}
}

type TopFlightsRsp struct {
	Status ResponseStatus    `json:"status"`
	Data   [][]TopFlightElem `json:"data"`
}

type TopFlightElem struct {
	Redirects int    `json:"redirects"`
	Numbers   string `json:"numbers"`
}
