package aviapersonalizationclient

import (
	"context"

	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/app/backend/internal/lib/clientscommon"
	personalsearch "a.yandex-team.ru/travel/avia/personalization/api/personal_search/v2"
	"a.yandex-team.ru/travel/library/go/grpcutil/client/ypresolver"
)

func NewGRPCClient(ctx context.Context, l log.Logger, config Config, registry metrics.Registry) (personalsearch.PersonalizationServiceV2Client, error) {
	metricsInterceptor := clientscommon.NewGrpcClientMetricsInterceptor(registry, "avia-personalization")
	conn, err := grpc.DialContext(
		ctx,
		ypresolver.BuildServiceFQDN(config.YPEndpointSetID),
		grpc.WithResolvers(ypresolver.NewYPResolverBuilder(ypresolver.WithClusters(config.YPClusters))),
		grpc.WithTransportCredentials(insecure.NewCredentials()),
		grpc.WithUnaryInterceptor(metricsInterceptor),
		grpc.WithBlock(),
	)
	if err != nil {
		return nil, err
	}
	return personalsearch.NewPersonalizationServiceV2Client(conn), nil
}
