package aviatdapiclient

import "time"

type Config struct {
	Timeout        time.Duration `config:"aviatdapi-timeout"`
	BaseURL        string        `config:"aviatdapi-baseurl,required"`
	InitRetryCount int           `config:"aviatdapi-initretrycount"`
	InitRetryWait  time.Duration `config:"aviatdapi-initretrywait"`
}

var DefaultConfig = Config{
	Timeout:        10 * time.Second,
	InitRetryCount: 2,
	InitRetryWait:  2 * time.Second,
}
