package calendarclient

import (
	"strconv"
	"time"

	"a.yandex-team.ru/travel/library/go/geobase/consts"
)

type Config struct {
	Timeout   time.Duration `config:"calendar-api-timeout"`
	BaseURL   string        `config:"calendar-api-baseurl,required"`
	GeoBaseID string
}

var DefaultConfig = Config{
	Timeout:   10 * time.Second,
	BaseURL:   "https://calendar-api.testing.yandex-team.ru",
	GeoBaseID: strconv.Itoa(consts.RussiaGeoID), // Россия
}
