package contentadminclient

import (
	"time"

	"a.yandex-team.ru/travel/library/go/contentadmin"
)

type Config struct {
	TvmID   uint32        `config:"contentadmin-tvmid,required" yaml:"tvmid"`
	Host    string        `config:"contentadmin-host,required" yaml:"host"`
	Timeout time.Duration `config:"contentadmin-timeout" yaml:"timeout"`
}

var DefaultConfig = Config{
	Host:    "testing.content-backend.rasp.yandex.net:9001",
	TvmID:   2025762,
	Timeout: 500 * time.Millisecond,
}

func (c *Config) toLibConfig() contentadmin.ContentAdminConfig {
	return contentadmin.ContentAdminConfig{
		TvmID:   c.TvmID,
		Host:    c.Host,
		Timeout: c.Timeout,
	}
}
