package exp3matcher

type argType string

const (
	// possible ArgTypes: https://wiki.yandex-team.ru/taxi/backend/architecture/experiments3/http/#vozmozhnyetipydannyx
	ArgTypeBool               = "bool"
	ArgTypeString             = "string"
	ArgTypeInt                = "int"
	ArgTypeApplication        = "application"
	ArgTypeApplicationVersion = "application_version"
	ArgTypeTimepoint          = "timepoint"
	ArgTypeSetString          = "set_string"
	ArgTypeSetInt             = "set_int"
)

type Arg struct {
	Name  string      `json:"name"`
	Type  argType     `json:"type"`
	Value interface{} `json:"value"`
}

type GetConfigsRequest struct {
	Consumer string `json:"consumer"`
	Args     []Arg  `json:"args"`
}

func (r *GetConfigsRequest) AddStringArg(name, value string) {
	r.Args = append(r.Args, Arg{
		name, ArgTypeString, value,
	})
}

func (r *GetConfigsRequest) AddApplicationVersionArg(name, value string) {
	r.Args = append(r.Args, Arg{
		name, ArgTypeApplicationVersion, value,
	})
}

func (r *GetConfigsRequest) AddIntArg(name string, value int) {
	r.Args = append(r.Args, Arg{
		name, ArgTypeInt, value,
	})
}

func (r *GetConfigsRequest) AddBoolArg(name string, value bool) {
	r.Args = append(r.Args, Arg{
		name, ArgTypeBool, value,
	})
}
