package priceindexclient

import "google.golang.org/genproto/googleapis/type/date"

type PriceReq struct {
	Start        date.Date
	End          date.Date
	DateForward  date.Date
	DateBackward *date.Date
	FromID       int
	ToID         int
	Adults       int
	Children     int
	Infants      int
}

type PriceBodyReq struct {
	//Filters       Filters `json:"filters"`
	FormatVersion string `json:"formatVersion"`
}
type Airport struct {
	BackwardArrival   []interface{} `json:"backwardArrival"`
	BackwardDeparture []interface{} `json:"backwardDeparture"`
	BackwardTransfers []interface{} `json:"backwardTransfers"`
	ForwardArrival    []interface{} `json:"forwardArrival"`
	ForwardDeparture  []interface{} `json:"forwardDeparture"`
	ForwardTransfers  []interface{} `json:"forwardTransfers"`
}
type Time struct {
	BackwardArrival   interface{} `json:"backwardArrival"`
	BackwardDeparture interface{} `json:"backwardDeparture"`
	ForwardArrival    interface{} `json:"forwardArrival"`
	ForwardDeparture  interface{} `json:"forwardDeparture"`
}
type Transfer struct {
	Count            interface{} `json:"count"`
	HasAirportChange interface{} `json:"hasAirportChange"`
	HasNight         interface{} `json:"hasNight"`
	MaxDuration      interface{} `json:"maxDuration"`
	MinDuration      interface{} `json:"minDuration"`
}
type Filters struct {
	Airlines    []interface{} `json:"airlines"`
	Airport     Airport       `json:"airport"`
	Time        Time          `json:"time"`
	Transfer    Transfer      `json:"transfer"`
	WithBaggage interface{}   `json:"withBaggage"`
}

type PriceRsp struct {
	Status    string               `json:"status"`
	DatePrice map[string]PriceData `json:"data"`
}
type PriceData struct {
	Currency  string  `json:"currency"`
	Value     int     `json:"value"`
	BaseValue float64 `json:"baseValue"`
	UpdatedAt string  `json:"updatedAt"`
	Status    string  `json:"status"`
}

type PriceBatchReq struct {
	Requests []*BatchReq
}
type BatchReq struct {
	FromID       int
	ToID         int
	DateForward  *date.Date
	DateBackward *date.Date
	Adults       *int
	Children     *int
	Infants      *int
}

type BatchBodyReqs struct {
	MinRequests []BatchBodyReq `json:"min_requests"`
}
type BatchBodyReq struct {
	FromID       int     `json:"from_id"`
	ToID         int     `json:"to_id"`
	ForwardDate  string  `json:"forward_date"`
	BackwardDate *string `json:"backward_date,omitempty"`
	Adults       *int    `json:"adults_count,omitempty"`
	Children     *int    `json:"children_count,omitempty"`
	Infants      *int    `json:"infants_count,omitempty"`
}

type PriceBatchRsp struct {
	Status string           `json:"status"`
	Data   []PriceBatchData `json:"data"`
}
type PriceBatchData struct {
	FromID       int      `json:"from_id"`
	ToID         int      `json:"to_id"`
	ForwardDate  string   `json:"forward_date"`
	BackwardDate *string  `json:"backward_date"`
	MinPrice     MinPrice `json:"min_price"`
	UpdatedAt    *string  `json:"updatedAt"`
	Adults       int      `json:"adults_count"`
	Children     int      `json:"children_count"`
	Infants      int      `json:"infants_count"`
	Expired      bool     `json:"expired"`
}
type MinPrice struct {
	Currency  string `json:"currency"`
	Value     int    `json:"value"`
	BaseValue int    `json:"baseValue"`
}
