package tankerclient

import "time"

type Config struct {
	BaseURL string
	Project string
	Token   string
	Timeout time.Duration
}

const defaultTimeout = time.Second * 30

func NewProductionConfig(project string, token string) Config {
	return Config{
		BaseURL: "https://tanker-beta.yandex-team.ru/api",
		Project: project,
		Timeout: defaultTimeout,
		Token:   token,
	}
}

func NewTestingConfig(project string, token string) Config {
	return Config{
		BaseURL: "https://sandbox.tanker-beta.yandex-team.ru/api",
		Project: project,
		Timeout: defaultTimeout,
		Token:   token,
	}
}
