package tankerclient

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

var (
	NoOAuthTokenError = xerrors.NewSentinel("tanker: no oauth token")
	ResponseError     = xerrors.NewSentinel("tanker: response error")
)

type StatusError struct {
	Status      int
	Response    map[string]interface{}
	ResponseRaw string
}

func (e StatusError) Error() string {
	return fmt.Sprintf("unexpected http status: %d", e.Status)
}
