package tankerclient

type TranslationStatus string

const (
	TranslationStatusRequiresTranslation TranslationStatus = "REQUIRES_TRANSLATION"
	TranslationStatusGenerated           TranslationStatus = "GENERATED"
	TranslationStatusApproved            TranslationStatus = "APPROVED"
	TranslationStatusExpired             TranslationStatus = "EXPIRED"
)

type KeysetContext struct {
	Text string `json:"text"`
}

type KeysetMeta struct {
	Languages           []string          `json:"languages"`
	AutoFillLanguages   []string          `json:"auto_fill_languages"`
	AutoApproveOriginal bool              `json:"auto_approve_original"`
	AutoApprove         bool              `json:"auto_approve"`
	OriginalLanguage    string            `json:"original_language"`
	JSONChecks          bool              `json:"json_checks"`
	Context             KeysetContext     `json:"context"`
	LanguagesFallback   map[string]string `json:"languages_fallback"`
}

type TranslationContents struct {
	SingularForm        *string `json:"singular_form,omitempty"`
	DualForm            *string `json:"dual_form,omitempty"`
	FewForm             *string `json:"few_form,omitempty"`
	ManyForm            *string `json:"many_form,omitempty"`
	ZeroForm            *string `json:"zero_form,omitempty"`
	OtherForm           *string `json:"other_form,omitempty"`
	TranslatorComment   *string `json:"translator_comment,omitempty"`
	LastApprovedVersion *int64  `json:"last_approved_version,omitempty"`
}

type ExportKeyTranslation struct {
	Language string              `json:"language"`
	Status   TranslationStatus   `json:"status"`
	Payload  TranslationContents `json:"payload"`
}

type KeyContextLinkDTO struct {
	Link  string `json:"link"`
	Title string `json:"title"`
}

type KeyContext struct {
	Text   string              `json:"text"`
	Links  []KeyContextLinkDTO `json:"links"`
	Images []KeyContextLinkDTO `json:"images"`
}

type KeyMeta struct {
	Context         KeyContext             `json:"context"`
	Locked          bool                   `json:"locked"`
	Plural          bool                   `json:"plural"`
	SourceReference string                 `json:"source_reference"`
	Array           bool                   `json:"array"`
	Position        int32                  `json:"position"`
	CustomData      map[string]interface{} `json:"custom_data"`
}

type ExportKeyData struct {
	Name         string                          `json:"name"`
	Translations map[string]ExportKeyTranslation `json:"translations"`
	Meta         KeyMeta                         `json:"meta"`
}

type KeysetExportData struct {
	Keys     map[string]ExportKeyData `json:"keys"`
	Meta     KeysetMeta               `json:"meta"`
	CommitID int64                    `json:"commit_id"`
}

type ExportResponse struct {
	Keysets map[string]KeysetExportData `json:"keysets"`
}
