package travelapiclient

import (
	"context"
	"encoding/json"
	"net/url"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/app/backend/internal/lib/travelapiclient/models"
)

// Avia order

func (c *HTTPClient) GetAviaOrderStatus(ctx context.Context, orderID string) (*models.GetAviaOrderStatusRsp, error) {
	res := models.GetAviaOrderStatusRsp{}
	body, err := c.execute2(ctx, resty.MethodGet, "/avia_booking_flow/v1/orders/state", nil, url.Values{
		"id": []string{orderID},
	})
	if err != nil {
		return nil, xerrors.Errorf("error while get avia order status :%w", err)
	}
	err = json.Unmarshal(body, &res)
	if err != nil {
		return nil, xerrors.Errorf("error while parse json avia order status :%w", err)
	}

	return &res, nil
}

func (c *HTTPClient) GetAviaOrder(ctx context.Context, orderID string) (*models.GetAviaOrderRsp, error) {
	res := models.GetAviaOrderRsp{}
	body, err := c.execute2(ctx, resty.MethodGet, "/avia_booking_flow/v1/orders/info", nil, url.Values{
		"id":     []string{orderID},
		"source": []string{"ORDER_PAGE"},
	})
	if err != nil {
		return nil, xerrors.Errorf("error while get avia order:%w", err)
	}
	err = json.Unmarshal(body, &res)
	if err != nil {
		return nil, xerrors.Errorf("error while parse json avia order:%w", err)
	}

	return &res, nil
}

func (c *HTTPClient) AviaStartPayment(ctx context.Context, orderID string) error {
	queryParams := url.Values{}
	queryParams.Add("id", orderID)
	body := models.AviaStartPaymentReq{
		PaymentRedirectURL:      c.config.PaymentRedirectURL,
		ConfirmationRedirectURL: c.config.ConfirmationRedirectURL,
		DeviceType:              "DT_MOBILE", //TODO(adurnev) нужно ли заводить новый тип в травелАпи?
	}
	err := c.execute(ctx, resty.MethodPost, "/avia_booking_flow/v1/orders/payment", body, nil, queryParams)
	if err != nil {
		return xerrors.Errorf("error while avia start payment :%w", err)
	}
	return nil
}

func (c *HTTPClient) GetAviaHappyPage(ctx context.Context, orderID string) (*models.GetAviaHappyPageRsp, error) {
	res := models.GetAviaHappyPageRsp{}
	err := c.execute(ctx, resty.MethodGet, "/orders/v1/get_order_happy_page", nil, &res, url.Values{
		"orderId": []string{orderID},
		"geoId":   []string{"0"}, //todo(adurnev)
	})
	if err != nil {
		return nil, xerrors.Errorf("error while get happy page :%w", err)
	}

	return &res, nil
}
