package travelapiclient

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/app/backend/internal/lib/travelapiclient/models"
)

func (c *HTTPClient) GetHotelFavorites(ctx context.Context, request *models.GetHotelFavoritesReq) (*models.GetHotelFavoritesRsp, error) {
	var result models.GetHotelFavoritesRsp
	queryParams := request.BuildURLParams()
	if err := c.execute(ctx, resty.MethodGet, searchPrefix+"/get_favorite_hotels", nil, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to hotels favorites request", log.Error(err))
		return nil, xerrors.Errorf("unable to hotels favorites request: %w", err)
	}

	for i := range result.Hotels {
		result.Hotels[i].Hotel.HotelURL = buildHotelURL(result.Hotels[i].Hotel.Slug, "", request.SearchParams)
	}

	return &result, nil
}

func (c *HTTPClient) AddHotelFavorites(ctx context.Context, request *models.AddHotelFavoritesReq) error {
	var result struct{}
	queryParams := request.BuildURLParams()
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/add_favorite_hotel", nil, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to add hotel favorites request", log.Error(err))
		return xerrors.Errorf("unable to add hotel favorites request: %w", err)
	}
	return nil
}

func (c *HTTPClient) RemoveHotelFavorites(ctx context.Context, request *models.RemoveHotelFavoritesReq) error {
	var result struct{}
	queryParams := request.BuildURLParams()
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/remove_favorite_hotels", nil, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to remove hotel favorites request", log.Error(err))
		return xerrors.Errorf("unable to remove hotel favorites request: %w", err)
	}
	return nil
}
