package travelapiclient

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/app/backend/internal/lib/travelapiclient/models"
)

func (c *HTTPClient) GetHotelReviews(ctx context.Context, request *models.GetHotelReviewsReq) (*models.GetHotelReviewsRsp, error) {
	var result models.GetHotelReviewsRsp
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodGet, searchPrefix+"/get_hotel_reviews", nil, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to hotels reviews request", log.Error(err))
		return nil, xerrors.Errorf("unable to hotels reviews request: %w", err)
	}
	return &result, nil
}

func (c *HTTPClient) AddHotelReview(ctx context.Context, request *models.AddHotelReviewReq) (*models.HotelReviewRsp, error) {
	var result models.HotelReviewRsp
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/add_hotel_review", request.Body, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to add hotel review request", log.Error(err))
		return nil, xerrors.Errorf("unable to add hotel review request: %w", err)
	}
	return &result, nil
}

func (c *HTTPClient) EditHotelReview(ctx context.Context, request *models.EditHotelReviewReq) (*models.HotelReviewRsp, error) {
	var result models.HotelReviewRsp
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/edit_hotel_review", request.Body, &result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to edit hotel review request", log.Error(err))
		return nil, xerrors.Errorf("unable to edit hotel review request: %w", err)
	}
	return &result, nil
}

func (c *HTTPClient) DeleteHotelReview(ctx context.Context, request *models.DeleteHotelReviewReq) error {
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/delete_hotel_review", nil, nil, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to delete hotel review request", log.Error(err))
		return xerrors.Errorf("unable to delete hotel review request: %w", err)
	}
	return nil
}

func (c *HTTPClient) SetReactionHotelReview(ctx context.Context, request *models.SetReactionHotelReviewReq) error {
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/set_hotel_review_reaction", nil, nil, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to set hotel review reaction request", log.Error(err))
		return xerrors.Errorf("unable to set hotel review reaction request: %w", err)
	}
	return nil
}

/*
UploadImageHotelReview Временно убрали из свагера, до момента полной реализации TRAVELAPP-1737
*/
func (c *HTTPClient) UploadImageHotelReview(ctx context.Context, request *models.UploadImageHotelReviewReq) (*models.UploadImageHotelReviewRsp, error) {
	var result models.UploadImageHotelReviewRsp
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/upload_hotel_review_image", nil, result, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to upload hotel review image request", log.Error(err))
		return nil, xerrors.Errorf("unable to upload hotel review image request: %w", err)
	}
	return &result, nil
}

func (c *HTTPClient) DeleteImagesHotelReview(ctx context.Context, request *models.DeleteImagesHotelReviewReq) error {
	queryParams := request.BuildURLParams(c.env)
	if err := c.execute(ctx, resty.MethodPost, searchPrefix+"/delete_hotel_review_images", request.Body, nil, queryParams); err != nil {
		ctxlog.Error(ctx, c.logger, "unable to delete hotel review images request", log.Error(err))
		return xerrors.Errorf("unable to delete hotel review images request: %w", err)
	}
	return nil
}
