package travelapiclient

import "time"

type TravelAPIConfig struct {
	BaseURL                 string        `config:"travel-api-baseurl,required" yaml:"baseurl"`
	Timeout                 time.Duration `config:"travel-api-timeout" yaml:"timeout"`
	PaymentRedirectURL      string        `config:"travel-api-paymentredirecturl" yaml:"paymentredirecturl"`
	ConfirmationRedirectURL string        `config:"travel-api-confirmationredirecturl" yaml:"confirmationredirecturl"`
}

var DefaultTravelAPIConfig = TravelAPIConfig{
	BaseURL:                 "https://api.travel-balancer-test.yandex.net/api",
	Timeout:                 10 * time.Second,
	PaymentRedirectURL:      "https://travel-test.yandex.ru/hotels/book/finishPayment",
	ConfirmationRedirectURL: "https://travel-test.yandex.ru/hotels/book/finishPayment", // TODO(adurnev) уточнить у приложения про 3dc
}
