package models

const (
	OrderStatusOsNew                   OrderStatus = "OS_NEW"
	OrderStatusOsCheckAvailability     OrderStatus = "OS_CHECK_AVAILABILITY"
	OrderStatusOsWaitCardTokenized     OrderStatus = "OS_WAIT_CARD_TOKENIZED"
	OrderStatusOsWaitOrderCreated      OrderStatus = "OS_WAIT_ORDER_CREATED"
	OrderStatusOsWaitOrderPaid         OrderStatus = "OS_WAIT_ORDER_PAID"
	OrderStatusOsConfirmed             OrderStatus = "OS_CONFIRMED"
	OrderStatusOsCancelled             OrderStatus = "OS_CANCELLED"
	OrderStatusOsAutoConfirmingInvoice OrderStatus = "OS_AUTO_CONFIRMING_INVOICE"
	OrderStatusOsCancellingOrderItem   OrderStatus = "OS_CANCELLING_ORDER_ITEM"
	OrderStatusOsCancellingInvoice     OrderStatus = "OS_CANCELLING_INVOICE"
	OrderStatusOsConfirmingOrderItem   OrderStatus = "OS_CONFIRMING_ORDER_ITEM"
	OrderStatusOsAutoRestoringInvoice  OrderStatus = "OS_AUTO_RESTORING_INVOICE"
	OrderStatusOsConfirmingOrder       OrderStatus = "OS_CONFIRMING_ORDER"
	OrderStatusOsExternallyCancelled   OrderStatus = "OS_EXTERNALLY_CANCELLED"
)

const (
	OrderStatusDisplayOsInProgress    OrderStatus = "OS_IN_PROGRESS"
	OrderStatusDisplayOsAwaitsPayment OrderStatus = "OS_AWAITS_PAYMENT"
	OrderStatusDisplayOsCancelled     OrderStatus = "OS_CANCELLED"
	OrderStatusDisplayOsFulfilled     OrderStatus = "OS_FULFILLED"
	OrderStatusDisplayOsRefunded      OrderStatus = "OS_REFUNDED"
)

type Flight struct {
	ID                   string      `json:"id"`
	From                 int         `json:"from"`
	To                   int         `json:"to"`
	MarketingAviaCompany int         `json:"marketing_avia_company"`
	OperatingAviaCompany int         `json:"operating_avia_company"`
	Number               string      `json:"number"`
	Arrival              string      `json:"arrival"`
	Departure            string      `json:"departure"`
	Stops                interface{} `json:"stops"`
	FareTerms            struct {
		BaseClass       string `json:"base_class"`
		TariffGroupName string `json:"tariff_group_name"`
		Terms           struct {
			Miles struct {
				Miles string `json:"miles"`
			} `json:"miles"`
			Baggage struct {
				Places       int      `json:"places"`
				SpecialNotes []string `json:"special_notes"`
			} `json:"baggage"`
			CarryOn struct {
				Places       int      `json:"places"`
				Weight       int      `json:"weight"`
				Size         string   `json:"size"`
				SpecialNotes []string `json:"special_notes"`
			} `json:"carry_on"`
			Refundable struct {
				Availability string `json:"availability"`
			} `json:"refundable"`
			DisclosureURL struct {
				SpecialNotes []string `json:"special_notes"`
			} `json:"disclosure_url"`
			OpenReturnDate struct {
				Availability string `json:"availability"`
			} `json:"open_return_date"`
			ChangingCarriage struct {
				Availability string   `json:"availability"`
				Charge       Price    `json:"charge"`
				SpecialNotes []string `json:"special_notes"`
			} `json:"changing_carriage"`
			RefundableNoShow struct {
				Availability string `json:"availability"`
			} `json:"refundable_no_show"`
			ChangingCarriageNoShow struct {
				Availability string `json:"availability"`
			} `json:"changing_carriage_no_show"`
		} `json:"terms"`
	} `json:"fare_terms"`
	SeatsLeft     interface{} `json:"seats_left"`
	AircraftSeats interface{} `json:"aircraft_seats"`
}

type AviaStartPaymentReq struct {
	DeviceType              string `json:"deviceType"`
	PaymentRedirectURL      string `json:"paymentRedirectUrl"`
	ConfirmationRedirectURL string `json:"confirmationRedirectUrl"`
}

type Airport struct {
	Settlement     int    `json:"settlement"`
	Code           string `json:"code"`
	PhraseFrom     string `json:"phrase_from"`
	Title          string `json:"title"`
	PhraseIn       string `json:"phrase_in"`
	PhraseTo       string `json:"phrase_to"`
	ID             int    `json:"id"`
	TimeZoneCode   string `json:"time_zone_code"`
	TimeZoneOffset int    `json:"time_zone_offset"`
	Ttype          string `json:"ttype"`
}

type Airline struct {
	Alliance   string `json:"alliance"`
	Title      string `json:"title"`
	URL        string `json:"url"`
	LogoSvg    string `json:"logo_svg"`
	Color      string `json:"color"`
	SirenaCode string `json:"sirena_code"`
	IataCode   string `json:"iata_code"`
	ID         int    `json:"id"`
}

type Settlement struct {
	ID         int    `json:"id"`
	CountryID  int    `json:"country_id"`
	Title      string `json:"title"`
	PhraseFrom string `json:"phrase_from"`
	PhraseIn   string `json:"phrase_in"`
	PhraseTo   string `json:"phrase_to"`
}

type Traveller struct {
	ID                string      `json:"id"`
	FirstName         string      `json:"first_name"`
	MiddleName        string      `json:"middle_name"`
	LastName          string      `json:"last_name"`
	Sex               string      `json:"sex"`
	Category          string      `json:"category"`
	DateOfBirth       string      `json:"date_of_birth"`
	DocumentNumber    string      `json:"document_number"`
	DocumentValidTill interface{} `json:"document_valid_till"`
	DocumentType      string      `json:"document_type"`
	PriceInfo         struct {
		Fare  Price `json:"fare"`
		Tax   Price `json:"tax"`
		Total Price `json:"total"`
	} `json:"price_info"`
	TicketNumber                interface{} `json:"ticket_number"`
	LoyaltyProgramInternalCode  interface{} `json:"loyalty_program_internal_code"`
	LoyaltyProgramAccountNumber interface{} `json:"loyalty_program_account_number"`
}

type Segment struct {
	Flights []Flight `json:"flights"`
}

type GetAviaHappyPageRsp struct {
	GetHappyPageRsp
	Order struct {
		ID             string `json:"id"`
		PrettyID       string `json:"pretty_id"`
		Partner        string `json:"partner"`
		VariantID      string `json:"variant_id"`
		Email          string `json:"email"`
		Phone          string `json:"phone"`
		AirReservation struct {
			Pnr        string      `json:"pnr"`
			PartnerRef interface{} `json:"partner_ref"`
			Segments   []Segment   `json:"segments"`
		} `json:"air_reservation"`
		Travellers       []Traveller `json:"travellers"`
		PreliminaryPrice Price       `json:"preliminary_price"`
		Price            Price       `json:"price"`
		State            string      `json:"state"`
		TimeLimitAt      interface{} `json:"time_limit_at"`
		ErrorCode        string      `json:"error_code"`
		Reference        struct {
			Airlines        []Airline     `json:"airlines"`
			Airports        []Airport     `json:"airports"`
			Settlements     []Settlement  `json:"settlements"`
			PartnerInfo     interface{}   `json:"partner_info"`
			LoyaltyPrograms []interface{} `json:"loyalty_programs"`
		} `json:"reference"`
		ServicedAt     string `json:"serviced_at"`
		PromoCampaigns struct {
			Promo2020     interface{} `json:"promo2020"`
			PlusPromo2021 interface{} `json:"plus_promo2021"`
		} `json:"promo_campaigns"`
		EdisplayOrderState OrderStatus `json:"edisplay_order_state"`
	} `json:"order"`
}

type GetAviaOrderStatusRsp struct {
	OrderState        OrderStatus `json:"orderState"`
	ServiceState      *string     `json:"serviceState"`
	InvoiceState      *string     `json:"invoiceState"`
	DisplayOrderState OrderStatus `json:"displayOrderState"`
	PaymentURL        *string     `json:"paymentUrl"`
	ConfirmationURL   *string     `json:"confirmationUrl"`
}

type GetAviaOrderRsp struct {
	AirReservation struct {
		PartnerRef string `json:"partnerRef"`
		Pnr        string `json:"pnr"`
		Segments   []struct {
			Flights []struct {
				AircraftSeats struct {
					Business int `json:"business"`
					Comfort  int `json:"comfort"`
					Economy  int `json:"economy"`
					First    int `json:"first"`
					Total    int `json:"total"`
				} `json:"aircraftSeats"`
				Arrival   string `json:"arrival"`   //dateTime
				Departure string `json:"departure"` //dateTime
				FareTerms struct {
					BaseClass       string `json:"baseClass"`
					TariffGroupName string `json:"tariffGroupName"`
					Terms           struct {
						AdditionalProp1 struct {
							Availability string   `json:"availability"`
							Charge       Price    `json:"charge"`
							Miles        string   `json:"miles"`
							Places       int      `json:"places"`
							Size         string   `json:"size"`
							SpecialNotes []string `json:"specialNotes"`
							SumSize      string   `json:"sumSize"`
							Weight       int      `json:"weight"`
						} `json:"additionalProp1"`
						AdditionalProp2 struct {
							Availability string   `json:"availability"`
							Charge       Price    `json:"charge"`
							Miles        string   `json:"miles"`
							Places       int      `json:"places"`
							Size         string   `json:"size"`
							SpecialNotes []string `json:"specialNotes"`
							SumSize      string   `json:"sumSize"`
							Weight       int      `json:"weight"`
						} `json:"additionalProp2"`
						AdditionalProp3 struct {
							Availability string   `json:"availability"`
							Charge       Price    `json:"charge"`
							Miles        string   `json:"miles"`
							Places       int      `json:"places"`
							Size         string   `json:"size"`
							SpecialNotes []string `json:"specialNotes"`
							SumSize      string   `json:"sumSize"`
							Weight       int      `json:"weight"`
						} `json:"additionalProp3"`
					} `json:"terms"`
				} `json:"fareTerms"`
				From                 int    `json:"from"`
				ID                   string `json:"id"`
				MarketingAviaCompany int    `json:"marketingAviaCompany"`
				Number               string `json:"number"`
				OperatingAviaCompany int    `json:"operatingAviaCompany"`
				SeatsLeft            int    `json:"seatsLeft"`
				Stops                []struct {
					AirportID int    `json:"airportId"`
					Terminal  string `json:"terminal"`
				} `json:"stops"`
				To int `json:"to"`
			} `json:"flights"`
		} `json:"segments"`
	} `json:"airReservation"`
	EdisplayOrderState OrderStatus `json:"edisplayOrderState"`
	Email              string      `json:"email"`
	ErrorCode          string      `json:"errorCode"`
	ID                 string      `json:"id"`
	Partner            string      `json:"partner"`
	Phone              string      `json:"phone"`
	PreliminaryPrice   Price       `json:"preliminaryPrice"`
	PrettyID           string      `json:"prettyId"`
	Price              Price       `json:"price"`
	PromoCampaigns     struct {
		PlusPromo2021 struct {
			Enabled         bool `json:"enabled"`
			TotalPlusPoints int  `json:"totalPlusPoints"`
		} `json:"plusPromo2021"`
		Promo2020 struct {
			Eligible bool `json:"eligible"`
		} `json:"promo2020"`
	} `json:"promoCampaigns"`
	Reference struct {
		Airlines []struct {
			Alliance   string `json:"alliance"`
			Color      string `json:"color"`
			IataCode   string `json:"iataCode"`
			ID         int    `json:"id"`
			LogoSvg    string `json:"logoSvg"`
			SirenaCode string `json:"sirenaCode"`
			Title      string `json:"title"`
			URL        string `json:"url"`
		} `json:"airlines"`
		Airports []struct {
			Code           string `json:"code"`
			ID             int    `json:"id"`
			PhraseFrom     string `json:"phraseFrom"`
			PhraseIn       string `json:"phraseIn"`
			PhraseTo       string `json:"phraseTo"`
			Settlement     int    `json:"settlement"`
			TimeZoneCode   string `json:"timeZoneCode"`
			TimeZoneOffset int    `json:"timeZoneOffset"`
			Title          string `json:"title"`
			Ttype          string `json:"ttype"`
		} `json:"airports"`
		LoyaltyPrograms []struct {
			InternalCode string `json:"internalCode"`
			Name         string `json:"name"`
		} `json:"loyaltyPrograms"`
		PartnerInfo struct {
			Code    string   `json:"code"`
			Email   string   `json:"email"`
			LogoURL string   `json:"logoUrl"`
			Phones  []string `json:"phones"`
			Title   string   `json:"title"`
		} `json:"partnerInfo"`
		Settlements []struct {
			CountryID  int    `json:"countryId"`
			ID         int    `json:"id"`
			PhraseFrom string `json:"phraseFrom"`
			PhraseIn   string `json:"phraseIn"`
			PhraseTo   string `json:"phraseTo"`
			Title      string `json:"title"`
		} `json:"settlements"`
	} `json:"reference"`
	ServicedAt     string `json:"servicedAt"` //dateTime
	State          string `json:"state"`
	StateRefreshed bool   `json:"stateRefreshed"`
	TimeLimitAt    string `json:"timeLimitAt"` //dateTime
	Travellers     []struct {
		Category                    string `json:"category"`
		DateOfBirth                 string `json:"dateOfBirth"`
		DocumentNumber              string `json:"documentNumber"`
		DocumentType                string `json:"documentType"`
		DocumentValidTill           string `json:"documentValidTill"`
		FirstName                   string `json:"firstName"`
		ID                          string `json:"id"`
		LastName                    string `json:"lastName"`
		LoyaltyProgramAccountNumber string `json:"loyaltyProgramAccountNumber"`
		LoyaltyProgramInternalCode  string `json:"loyaltyProgramInternalCode"`
		MiddleName                  string `json:"middleName"`
		PriceInfo                   struct {
			Fare  Price `json:"fare"`
			Tax   Price `json:"tax"`
			Total Price `json:"total"`
		} `json:"priceInfo"`
		Sex          string `json:"sex"`
		TicketNumber string `json:"ticketNumber"`
	} `json:"travellers"`
	TripID    string `json:"tripId"`
	VariantID string `json:"variantId"`
}
