package models

import (
	"net/url"
	"strconv"
)

type GetHotelFavoritesReq struct {
	AnalyticsParams *AnalyticsParams
	SearchParams    *SearchParams
	CategoryID      string
	PagingParams    *PagingParams
}

func (r GetHotelFavoritesReq) BuildURLParams() url.Values {
	queryParams := url.Values{}

	if r.CategoryID != "" {
		queryParams.Add("category_id", r.CategoryID)
	}
	if r.PagingParams != nil {
		queryParams.Add("limit", strconv.Itoa(r.PagingParams.Limit))
		queryParams.Add("offset", strconv.Itoa(r.PagingParams.Offset))
	}
	addHotelSearchParams(r.SearchParams, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	return queryParams
}

type GetHotelFavoritesRsp struct {
	Categories         []Categories      `json:"categories"`
	Hotels             []HotelWithOffers `json:"hotels"`
	SelectedCategoryID string            `json:"selected_category_id"`
	TotalHotelCount    int               `json:"total_hotel_count"`
	OfferSearchParams  *SearchParams     `json:"offer_search_params"`
}
type Categories struct {
	Category
	HotelCount int `json:"hotel_count"`
}

type RemoveHotelFavoritesReq struct {
	AnalyticsParams *AnalyticsParams
	Permalink       *uint64
	CategoryID      *string
}

func (r RemoveHotelFavoritesReq) BuildURLParams() url.Values {
	queryParams := url.Values{}

	if r.Permalink != nil {
		queryParams.Add("permalink", strconv.Itoa(int(*r.Permalink)))
	}
	if r.CategoryID != nil {
		queryParams.Add("category_id", *r.CategoryID)
	}

	addAnalyticsParams(r.AnalyticsParams, queryParams)
	return queryParams
}

type AddHotelFavoritesReq struct {
	AnalyticsParams *AnalyticsParams
	Permalink       *uint64
}

func (r AddHotelFavoritesReq) BuildURLParams() url.Values {
	queryParams := url.Values{}

	queryParams.Add("permalink", strconv.Itoa(int(*r.Permalink)))

	addAnalyticsParams(r.AnalyticsParams, queryParams)
	return queryParams
}
