package models

import (
	"net/url"
	"strconv"

	"a.yandex-team.ru/travel/app/backend/internal/common"
)

type GetHotelReviewsReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	PagingParams    *PagingParams
	Sort            string
	Phrase          *PhraseReq
}

func (r GetHotelReviewsReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	addHotelReviewSort(r.Sort, queryParams)
	addHotelReviewKeyPhrase(r.Phrase, queryParams)
	addHotelReviewPaging(r.PagingParams, queryParams)
	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

type PhraseReq struct {
	Filter string
	Limit  int
}
type GetHotelReviewsRsp struct {
	ReviewsInfo ReviewsInfo `json:"reviews_info"`
}
type AddHotelReviewReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	Body            HotelReviewReq
}
type HotelReviewReq struct {
	ImageIds []string `json:"reviewImageIds,omitempty"`
	Rating   int      `json:"reviewRating"`
	Text     string   `json:"reviewText"`
}
type EditHotelReviewReq struct {
	AddHotelReviewReq
	ReviewID string
}
type HotelReviewRsp struct {
	TextReview *TextReview `json:"text_review"`
}
type DeleteHotelReviewReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	ReviewID        string
}
type SetReactionHotelReviewReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	ReviewID        string
	Reaction        string
}
type UploadImageHotelReviewReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	Image           []byte
}

type UploadImageHotelReviewRsp struct {
	ImageID string            `json:"imageId"`
	Sizes   []UploadImageSize `json:"sizes"`
}
type UploadImageSize struct {
	Height string `json:"height"`
	Size   string `json:"size"`
	URL    string `json:"url"`
	Width  string `json:"width"`
}
type DeleteImagesHotelReviewReq struct {
	AnalyticsParams *AnalyticsParams
	QueryData       GetHotelInfoQueryData
	Body            DeleteImagesHotelReviewReqBody
}
type DeleteImagesHotelReviewReqBody struct {
	ImageIds []string `json:"imageIds"`
}

func (r AddHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func (r EditHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	addReviewID(r.ReviewID, queryParams)
	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func (r DeleteHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	addReviewID(r.ReviewID, queryParams)
	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func (r SetReactionHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	queryParams.Add("user_reaction ", r.Reaction)
	addReviewID(r.ReviewID, queryParams)
	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func (r UploadImageHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	//queryParams.Add("image ", r.Reaction)
	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func (r DeleteImagesHotelReviewReq) BuildURLParams(env common.EnvType) url.Values {
	queryParams := url.Values{}

	addHotelInfoParams(&r.QueryData, queryParams)
	addAnalyticsParams(r.AnalyticsParams, queryParams)
	addTestUGC(env, queryParams)
	return queryParams
}

func addReviewID(reviewID string, queryParams url.Values) {
	queryParams.Add("review_id", reviewID)
}

func addTestUGC(env common.EnvType, queryParams url.Values) {
	if env != common.ProductionEnv {
		queryParams.Add("enabled_test_ugc", strconv.FormatBool(true))
	}
}
