package travelersclient

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

var (
	NoServiceTicketError = xerrors.NewSentinel("travelers: no service ticket")
	NoUserTicketError    = xerrors.NewSentinel("travelers: no user ticket")
	ResponseError        = xerrors.NewSentinel("travelers: response error")
	InternalError        = xerrors.NewSentinel("travelers: internal error")
)

type StatusError struct {
	Status      int
	Response    map[string]interface{}
	ResponseRaw string
}

func (e StatusError) Error() string {
	return fmt.Sprintf("unexpected http status: %d", e.Status)
}

type ValidationError struct {
	FieldErrors map[string]string
}

func (e ValidationError) Error() string {
	return fmt.Sprintf("illegal value for field(s): %v", e.FieldErrors)
}
