package factories

var (
	GeoIDCounter        = &Counter{}
	CountryIDCounter    = &Counter{}
	RegionIDCounter     = &Counter{}
	SettlementIDCounter = &Counter{}
	StationIDCounter    = &Counter{value: 1000}
)

type Counter struct {
	value int32
}

func (c *Counter) Next() int32 {
	c.value++
	return c.value
}

func (c *Counter) MarkUsed(value int32) {
	if c.value < value {
		c.value = value
	}
}
